ORCA/M Asm65816 2.1.0

0001 877D              ***          Copyright Apple Computer, Inc. 1985-1989        ***
0002 877D              ***          All Rights Reserved                             ***
0003 877D
0004 877D              ************************************************************
0005 877D              *
0006 877D              * SStartup Tool inits the Sound Tool set its WAP. It Does
0007 877D              * a SShutDown first if necessary.
0008 877D              *
0009 877D              *   Called: push DirectPageAdr
0010 877D              *           _SoundStartup
0011 877D              *
0012 877D              *  Returns: error if DOC not installed
0013 877D              *
0014 877D              ************************************************************
0015 877D              *
0016 877D              * 22-Oct-90 Dave Lyons
0017 877D              *
0018 877D              * Made illmode_error into a separate PROC so it doesn't
0019 877D              * get linked into TS3 unnecessarily.
0020 877D              *
0021 877D              ************************************************************
0022 877D                       include 'all.macros' 
0023 877D                       include 'Snd.Equ.aii' 
0024 877D
0025 877D                       import fsynth_irq 
0026 877D
0027 877D
0028 877D                       LONGA ON                       ; native m=0, x=0
0029 877D                       LONGI ON                       ;
0030 877D              ;
0031 877D              *
0032 877D                       export SStartup 
0033 877D              SStartup proc                           ;
0034 877D AF D6 00 E1           lda   >DOCFlag                 ; is DOC installed?
0035 8781 29 FF 00              and   #$FF                     ; for low-byte only
0036 8784 F0 0A                 beq   SSt1                     ; yes, go on
0037 8786 A2 10 08              ldx   #NoDOCErr                ; get error message
0038 8789 A0 02 00 5C           oeout 2 
0039 8790              SSt1                                    ;
0040 8790 20 EE 8A              jsr   SStartChk                ; are we already started?
0041 8793 F0 0C                 beq   SSt2                     ; no, we're shut down
0042 8795 A2 18 08              ldx   #start_err               ; startup error
0043 8798 A0 02 00 5C           oeout 2 
0044 879F                       LONGA ON                       ;
0045 879F C2 20                 rep   #$20                     ;
0046 87A1 A3 07        SSt2     lda   W1,S                     ; get the passed direct page addr.
0047 87A3 8F B7 1D E1           sta   >sram_base+wap_addr      ; save the zero page pointer
0048 87A7 F4 00 00 F4           SetWAP 0,MyToolNum 
0049 87B8 0B                    phd                            ; save current direct register
0050 87B9 AF B7 1D E1           lda   >sram_base+wap_addr      ; get our work zero page
0051 87BD 5B                    tcd                            ; save our zero page
0052 87BE A2 FA 00              ldx   #zpg_size-1              ; clear zero page work area
0053 87C1                       LONGA OFF                      ;
0054 87C1 E2 20                 sep   #$20                     ;
0055 87C3 A9 00                 lda   #00                      ;
0056 87C5              zpg_zap_loop                            ;
0057 87C5 95 00                 sta   gcb_tbl,x                ;
0058 87C7 CA                    dex                            ;
0059 87C8 10 FB                 bpl   zpg_zap_loop             ;
0060 87CA 2B                    pld                            ; restore zero page
0061 87CB A9 FF                 lda   #$FF                     ; set the wap initialized flag
0062 87CD 8F B6 1D E1           sta   >sram_base+wap_installed
0063 87D1 8F C1 1D E1           sta   >sram_base+start_stat    ; mark startup call made status
0064 87D5                       LONGA ON
0065 87D5 C2 20                 rep   #$20                     ;
0066 87D7 F4 02 00 F4           PushLong #fsynth_irq           ; address of sound interrupt handler
0067 87DD A2 08 12 22           _SetSoundMIRQV 
0068 87E4 A0 02 00 A2           oendc 2 
0069 87EE
0070 87EE              *
0071 87EE              * Test if wap assigned
0072 87EE              *
0073 87EE                       LONGA OFF                      ;
0074 87EE                       LONGI ON                       ;
0075 87EE              SStartChk                               ;
0076 87EE E2 20                 sep   #$20                     ;
0077 87F0 AF B6 1D E1           lda   >sram_base+wap_installed ; wap installed?
0078 87F4 C2 20                 rep   #$20                     ;
0079 87F6 60           SSOK     rts   
0080 87F7
0081 87F7                       endp 
0082 87F7
0083 87F7
0084 87F7                       end   
